<?php
$body = '
<p>Oto drzewo i krzew iglasty.</p>

<a href="krzew.php"><img src="krzew.jpg"/>Zdjcie przedstawia krzew iglasty</a>

Zgodnie z definicj drzewostan to zesp wikszej liczby drzew.

<drzewo>Drzewo nie jest elementem HTML!</drzewo>
';

$words = array('drzewo','krzew');
$patterns = array();
$replacements = array();
foreach ($words as $i => $word) {
    $patterns[] = '/' . preg_quote($word) .'/i';
    $replacements[] = "<span class='word-$i'>\\0</span>";
}

// Podzielenie strony na fragmenty odpowiadajce
// wzrocowi standardowych elementw HTML.
$parts = preg_split("{(<(?:\"[^\"]*\"|'[^']*'|[^'\">])*>)}",
                    $body,
                    -1,  // Nieograniczona liczba fragmentw
                    PREG_SPLIT_DELIM_CAPTURE);
foreach ($parts as $i => $part) {
    // Pominicie elementu HTML
    if (isset($part[0]) && ($part[0] == '<')) { continue; }
    // Otoczenie sw znacznikami <span/>
    $parts[$i] = preg_replace($patterns, $replacements, $part);
}

// Odtworzenie treci
$body = implode('',$parts);

print $body;
?>
